<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
* @filesource
*/

require_once 'entity.php';

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/
class DAS_log_entry extends Entity {
	static $table = 'das_results';	
	static $primary_key = 'id';
		


	public static function find_for_attachment($attachment, $id_or_conditions = array(), $key_by = null){
		if(!is_a($attachment, 'Attachment')) return $this->error->should_be_an_attachment($attachment);
		if($attachment->schema != 'C32') return $this->error->should_be_a_c32_attachment($attachment);
		
		if(!$attachment->property_is_empty('message_id'))
			static::db()->where('message_id', $attachment->message_id);
		
		static::db()->where('attachment_name', $attachment->name);
		
		return static::find($id_or_conditions, $key_by);
	}
	
	public static function find_one_for_attachment($attachment, $id_or_conditions=array()){
		static::db()->limit(1);
		return first_element(static::find_for_attachment($attachment, $id_or_conditions));
	}
		
}